<?php $attributes = $attributes->exceptProps(['sale', 'activeTab', 'modalProducts', 'modalPayments']); ?>
<?php foreach (array_filter((['sale', 'activeTab', 'modalProducts', 'modalPayments']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div wire:ignore.self class="modal fade" id="salePreviewModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header bg-primary">
        <h5 class="modal-title text-white">
          <b>Vista Previa de Venta</b>
        </h5>
        <button class="close" data-dismiss="modal" type="button" aria-label="Close" wire:click="resetModal">
          <span class="text-white">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <?php if($sale): ?>
          
          <div class="row mb-4">
            <div class="col-12 col-md-6 mb-3 mb-md-0">
              <h6 class="font-weight-bold">Cliente:</h6>
              <p class="mb-1"><?php echo e($sale->client->name); ?> <?php echo e($sale->client->last_name); ?></p>
              <?php if(auth()->user()->roles->pluck('reference')->first() === 'admin'): ?>
                <small class="text-muted">Documento: <?php echo e($sale->client->document); ?></small>
              <?php endif; ?>
            </div>
            <div class="col-12 col-md-6 text-md-right">
              <h6 class="font-weight-bold">Información de Venta:</h6>
              <p class="mb-1">Código: <strong>#<?php echo e($sale->code); ?></strong></p>
              <p class="mb-1">Fecha: <?php echo e($sale->created_at->format('d-m-Y h:i a')); ?></p>
              <p class="mb-0">Estado:
                <span class="badge badge-<?php echo e($sale->status === 'PAID' ? 'success' : 'warning'); ?>">
                  <?php echo e($sale->status === 'PAID' ? 'PAGADO' : 'PENDIENTE'); ?>

                </span>
              </p>
            </div>
          </div>

          
          <ul class="nav nav-tabs" id="salePreviewTabs" role="tablist">
            <li class="nav-item">
              <a class="nav-link <?php echo e($activeTab === 'products' ? 'active' : ''); ?>" id="products-tab"
                wire:click="$set('activeTab','products')" href="javascript:void(0)" role="tab">
                <i class="fas fa-boxes mr-1"></i> Productos
                <span class="badge badge-primary ml-1"><?php echo e($sale->products->count()); ?></span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link <?php echo e($activeTab === 'payments' ? 'active' : ''); ?>" id="payments-tab"
                wire:click="$set('activeTab','payments')" href="javascript:void(0)" role="tab">
                <i class="fas fa-money-bill-wave mr-1"></i> Pagos
                <span class="badge badge-info ml-1"><?php echo e($sale->payments->count()); ?></span>
              </a>
            </li>
          </ul>

          
          <div class="tab-content" id="salePreviewTabsContent">
            
            <div class="tab-pane fade <?php echo e($activeTab === 'products' ? 'show active' : ''); ?>" id="products" role="tabpanel">
              <div class="mt-3">
                
                <div class="table-responsive">
                  <table class="table table-bordered table-striped">
                    <thead class="bg-light">
                      <tr>
                        <th>Producto</th>
                        <th class="text-center">Precio Unitario</th>
                        <th class="text-center">Cantidad</th>
                        <th class="text-center">Subtotal</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $modalProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $itemSubtotal = $detail->price * $detail->quantity; ?>
                        <tr>
                          <td>
                            <div class="d-flex align-items-center">
                              <img src="<?php echo e($detail->product->getImage()); ?>" alt="<?php echo e($detail->product->name); ?>"
                                class="rounded mr-3" style="width: 50px; height: 50px; object-fit: cover;">
                              <div>
                                <h6 class="mb-0"><?php echo e($detail->product->name); ?></h6>
                                <small class="text-muted">SKU: <?php echo e($detail->product->code ?? 'N/A'); ?></small><br>
                                <small class="text-muted">Stock: <?php echo e($detail->product->stock); ?></small>
                              </div>
                            </div>
                          </td>
                          <td class="text-center">$<?php echo e(number_format($detail->price, 2)); ?></td>
                          <td class="text-center">
                            <span class="badge badge-primary badge-pill"><?php echo e($detail->quantity); ?></span>
                          </td>
                          <td class="text-center font-weight-bold">$<?php echo e(number_format($itemSubtotal, 2)); ?></td>
                        </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>

                <?php echo e($modalProducts->links('pagination::bootstrap-4', ['paginator' => 'productsPage'])); ?>


                
                <div class="row mt-3">
                  <div class="col-12">
                    <div class="card bg-light">
                      <div class="card-body py-2">
                        <div class="row text-center">
                          <div class="col-6">
                            <strong>Total Productos:</strong>
                            <div class="h5 mb-0 text-primary"><?php echo e($this->productsTotals['totalQuantity']); ?></div>
                          </div>
                          <div class="col-6">
                            <strong>Total:</strong>
                            <div class="h5 mb-0 text-dark">$<?php echo e(number_format($this->productsTotals['subtotal'], 2)); ?>

                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            
            <div class="tab-pane fade <?php echo e($activeTab === 'payments' ? 'show active' : ''); ?>" id="payments" role="tabpanel">
              <div class="mt-3">
                
                <div class="row mb-4">
                  <div class="col-md-4 mb-3">
                    <div class="card border-success">
                      <div class="card-body text-center py-3">
                        <i class="fas fa-dollar-sign fa-2x text-success mb-2"></i>
                        <div class="h5 mb-1 text-success">
                          $<?php echo e(number_format($this->paymentSummary['total_payed_usd'] ?? 0, 2)); ?></div>
                        <small class="text-muted font-weight-bold">PAGADO EN USD</small>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4 mb-3">
                    <div class="card border-info">
                      <div class="card-body text-center" style="padding: 1.719rem 0;">
                        <i class="fas fa-bolivar-sign fa-2x text-info mb-2"></i>
                        <div class="h5 mb-1 text-info">
                          <?php echo e(number_format($this->paymentSummary['total_payed_bs'] ?? 0, 2)); ?> Bs
                        </div>
                        <small class="text-muted font-weight-bold">PAGADO EN BOLÍVARES</small>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4 mb-3">
                    <div class="card <?php echo e($sale->status === 'PAID' ? 'border-success' : 'border-warning'); ?>">
                      <div class="card-body text-center" style="padding: 1.401rem 0;">
                        <i
                          class="fas fa-<?php echo e($sale->status === 'PAID' ? 'check-circle' : 'clock'); ?> fa-2x text-<?php echo e($sale->status === 'PAID' ? 'success' : 'warning'); ?> mb-2"></i>
                        <div class="h6 mb-1 text-<?php echo e($sale->status === 'PAID' ? 'success' : 'warning'); ?>">
                          <?php echo e($sale->status === 'PAID' ? 'COMPLETADO' : 'PENDIENTE'); ?>

                        </div>
                        <small class="text-muted font-weight-bold">ESTADO</small>
                      </div>
                    </div>
                  </div>
                </div>

                
                <?php if($sale->payments->count()): ?>
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                      <thead class="bg-light">
                        <tr>
                          <th class="text-center">#</th>
                          <th class="text-center">Fecha y Hora</th>
                          <th class="text-center">Efectivo Recibido</th>
                          <th class="text-center">Cambio Entregado</th>
                          <th class="text-center">Neto USD</th>
                          <th class="text-center">Tasa</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php $__currentLoopData = $modalPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <?php
                            $netUSD = $payment->cash_usd - $payment->change_usd;
                            $netBS = $payment->cash_bs - $payment->change_bs;
                            $netTotalUSD = $netUSD + ($netBS / $payment->currency->value);
                          ?>
                          <tr>
                            <td class="text-center">
                              <?php echo e($index + 1 + (($modalPayments->currentPage() - 1) * $modalPayments->perPage())); ?>

                            </td>
                            <td>
                              <?php echo e($payment->created_at->format('d-m-Y h:i a')); ?>

                            </td>
                            <td class="text-center">
                              <div class="text-success font-weight-bold">$<?php echo e(number_format($payment->cash_usd, 2)); ?></div>
                              <div class="text-success small"><?php echo e(number_format($payment->cash_bs, 2)); ?> Bs</div>
                            </td>
                            <td class="text-center">
                              <div class="text-danger">$<?php echo e(number_format($payment->change_usd, 2)); ?></div>
                              <div class="text-danger small"><?php echo e(number_format($payment->change_bs, 2)); ?> Bs</div>
                            </td>
                            <td class="text-center font-weight-bold bg-light">$<?php echo e(number_format($netTotalUSD, 2)); ?></td>
                            <td class="text-center text-muted small"><?php echo e(number_format($payment->currency->value, 2)); ?></td>
                          </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tbody>
                    </table>
                  </div>

                  <?php echo e($modalPayments->links('pagination::bootstrap-4', ['paginator' => 'paymentsPage'])); ?>

                <?php else: ?>
                  <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle fa-2x mb-3"></i>
                    <h5>No hay pagos registrados</h5>
                    <p class="mb-0">Esta venta no tiene pagos registrados aún.</p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal" wire:click="resetModal">
          Cerrar
        </button>
        <?php if($sale && $sale->status === 'PENDING'): ?>
          <button type="button" wire:click="edit(<?php echo e($sale->id); ?>)" class="btn btn-primary" data-dismiss="modal">
            Gestionar Pago
          </button>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div><?php /**PATH /home2/motopart/public_html/sistema/resources/views/components/carts/preview_sale.blade.php ENDPATH**/ ?>